"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CachingSubgraphProvider = exports.BASES_TO_CHECK_TRADES_AGAINST = void 0;
const sdk_core_1 = require("@uniswap/sdk-core");
const util_1 = require("../util");
const token_provider_1 = require("./token-provider");
exports.BASES_TO_CHECK_TRADES_AGAINST = {
    [sdk_core_1.ChainId.MAINNET]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.MAINNET),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.MAINNET],
        token_provider_1.DAI_MAINNET,
        token_provider_1.USDC_MAINNET,
        token_provider_1.USDT_MAINNET,
        token_provider_1.WBTC_MAINNET,
        token_provider_1.WSTETH_MAINNET,
    ],
    [sdk_core_1.ChainId.GOERLI]: [util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.GOERLI]],
    [sdk_core_1.ChainId.SEPOLIA]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.SEPOLIA),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.SEPOLIA],
    ],
    //v2 not deployed on [arbitrum, polygon, celo, gnosis, moonbeam, bnb, avalanche] and their testnets
    [sdk_core_1.ChainId.OPTIMISM]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.OPTIMISM),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.OPTIMISM],
        token_provider_1.USDC_OPTIMISM,
        token_provider_1.DAI_OPTIMISM,
        token_provider_1.USDT_OPTIMISM,
        token_provider_1.WBTC_OPTIMISM,
        token_provider_1.OP_OPTIMISM,
    ],
    [sdk_core_1.ChainId.ARBITRUM_ONE]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.ARBITRUM_ONE),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.ARBITRUM_ONE],
        token_provider_1.WBTC_ARBITRUM,
        token_provider_1.DAI_ARBITRUM,
        token_provider_1.USDC_ARBITRUM,
        token_provider_1.USDC_NATIVE_ARBITRUM,
        token_provider_1.USDT_ARBITRUM,
        token_provider_1.ARB_ARBITRUM,
    ],
    [sdk_core_1.ChainId.ARBITRUM_GOERLI]: [],
    [sdk_core_1.ChainId.ARBITRUM_SEPOLIA]: [],
    [sdk_core_1.ChainId.OPTIMISM_GOERLI]: [],
    [sdk_core_1.ChainId.OPTIMISM_SEPOLIA]: [],
    [sdk_core_1.ChainId.POLYGON]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.POLYGON),
        token_provider_1.USDC_POLYGON,
        token_provider_1.WETH_POLYGON,
        token_provider_1.WMATIC_POLYGON,
    ],
    [sdk_core_1.ChainId.POLYGON_MUMBAI]: [],
    [sdk_core_1.ChainId.CELO]: [token_provider_1.CELO, token_provider_1.CUSD_CELO, token_provider_1.CEUR_CELO, token_provider_1.DAI_CELO],
    [sdk_core_1.ChainId.CELO_ALFAJORES]: [],
    [sdk_core_1.ChainId.GNOSIS]: [],
    [sdk_core_1.ChainId.MOONBEAM]: [
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.MOONBEAM],
        token_provider_1.DAI_MOONBEAM,
        token_provider_1.USDC_MOONBEAM,
        token_provider_1.WBTC_MOONBEAM,
    ],
    [sdk_core_1.ChainId.BNB]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.BNB),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.BNB],
        token_provider_1.BUSD_BNB,
        token_provider_1.DAI_BNB,
        token_provider_1.USDC_BNB,
        token_provider_1.USDT_BNB,
        token_provider_1.BTC_BNB,
        token_provider_1.ETH_BNB,
    ],
    [sdk_core_1.ChainId.AVALANCHE]: [
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.AVALANCHE],
        token_provider_1.USDC_AVAX,
        token_provider_1.DAI_AVAX,
    ],
    [sdk_core_1.ChainId.BASE_GOERLI]: [],
    [sdk_core_1.ChainId.BASE]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.BASE),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.BASE],
        token_provider_1.USDC_BASE,
    ],
    [sdk_core_1.ChainId.ZORA]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.ZORA),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.ZORA],
    ],
    [sdk_core_1.ChainId.ZORA_SEPOLIA]: [util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.ZORA_SEPOLIA]],
    [sdk_core_1.ChainId.ROOTSTOCK]: [util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.ROOTSTOCK]],
    [sdk_core_1.ChainId.BLAST]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.BLAST),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.BLAST],
        token_provider_1.USDB_BLAST,
    ],
    [sdk_core_1.ChainId.ZKSYNC]: [
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.ZKSYNC],
        token_provider_1.USDCE_ZKSYNC,
        token_provider_1.USDC_ZKSYNC,
    ],
    [sdk_core_1.ChainId.WORLDCHAIN]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.WORLDCHAIN),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.WORLDCHAIN],
        token_provider_1.USDC_WORLDCHAIN,
        token_provider_1.WLD_WORLDCHAIN,
        token_provider_1.WBTC_WORLDCHAIN,
    ],
    [sdk_core_1.ChainId.UNICHAIN_SEPOLIA]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.UNICHAIN_SEPOLIA),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.UNICHAIN_SEPOLIA],
        token_provider_1.USDC_UNICHAIN_SEPOLIA,
    ],
    [sdk_core_1.ChainId.UNICHAIN]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.UNICHAIN),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.UNICHAIN],
        token_provider_1.DAI_UNICHAIN,
        token_provider_1.USDC_UNICHAIN,
    ],
    [sdk_core_1.ChainId.BASE_SEPOLIA]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.BASE_SEPOLIA),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.BASE_SEPOLIA],
        token_provider_1.USDC_BASE_SEPOLIA,
    ],
    [sdk_core_1.ChainId.MONAD_TESTNET]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.MONAD_TESTNET),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.MONAD_TESTNET],
        token_provider_1.USDT_MONAD_TESTNET,
    ],
    [sdk_core_1.ChainId.SONEIUM]: [
        (0, util_1.nativeOnChain)(sdk_core_1.ChainId.SONEIUM),
        util_1.WRAPPED_NATIVE_CURRENCY[sdk_core_1.ChainId.SONEIUM],
        token_provider_1.USDC_SONEIUM,
    ],
};
class CachingSubgraphProvider {
    /**
     * Creates an instance of CachingV3SubgraphProvider.
     * @param chainId The chain id to use.
     * @param subgraphProvider The provider to use to get the subgraph pools when not in the cache.
     * @param cache Cache instance to hold cached pools.
     * @param protocol Subgraph protocol version
     */
    constructor(chainId, subgraphProvider, cache, protocol) {
        this.chainId = chainId;
        this.subgraphProvider = subgraphProvider;
        this.cache = cache;
        this.protocol = protocol;
        this.SUBGRAPH_KEY = (chainId) => `subgraph-pools-${this.protocol}-${chainId}`;
    }
    async getPools() {
        const cachedPools = await this.cache.get(this.SUBGRAPH_KEY(this.chainId));
        if (cachedPools) {
            return cachedPools;
        }
        const pools = await this.subgraphProvider.getPools();
        await this.cache.set(this.SUBGRAPH_KEY(this.chainId), pools);
        return pools;
    }
}
exports.CachingSubgraphProvider = CachingSubgraphProvider;
//# sourceMappingURL=data:application/json;base64,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